<?php
require __DIR__ . '/sendMail.php';

$employees = array_map('str_getcsv', file(__DIR__ . '/birthdays.csv'));
array_shift($employees); // remove header

$today = date('Y-m-d');

foreach ($employees as $emp) {
    list($name, $email, $dob, $dept, $photo) = $emp;
    $dobThisYear = date('Y') . '-' . date('m-d', strtotime($dob));
    $reminderDate = date('Y-m-d', strtotime($dobThisYear . ' -10 days'));

    if ($today == $reminderDate) {
        $subject = "Upcoming Birthday Reminder: $name";
        $body = "Hi Team,<br><br>Reminder: $name from $dept department has a birthday on " . date('F j', strtotime($dobThisYear)) . ".<br><br>Regards,<br>HR Team";

        foreach ($employees as $teamMember) {
            $teamEmail = $teamMember[1];
            if ($teamEmail != $email) { // exclude birthday person
                $result = sendMail($teamEmail, $subject, $body);
                $log = date("Y-m-d H:i:s") . " - Reminder email to $teamEmail about $name - " . ($result === true ? "Sent" : "Failed: $result") . "\n";
                file_put_contents(__DIR__ . "/logs/reminder.log", $log, FILE_APPEND);
            }
        }
    }
}
?>