<?php
require __DIR__ . '/sendMail.php';

$employees = array_map('str_getcsv', file(__DIR__ . '/birthdays.csv'));
array_shift($employees); // remove header

$today = date('m-d');

foreach ($employees as $emp) {
    list($name, $email, $dob, $dept, $photo) = $emp;
    if (date('m-d', strtotime($dob)) == $today) {
        $emailTemplate = file_get_contents(__DIR__ . '/index.html');
        $emailTemplate = str_replace('&lt;NAME&gt;', htmlspecialchars($name, ENT_QUOTES), $emailTemplate);
        $emailTemplate = str_replace('&lt;PHOTO&gt;', rawurlencode($photo), $emailTemplate);

        $subject = "🎉 Happy Birthday, $name!";

        $result = sendMail($email, $subject, $emailTemplate);

        $log = date("Y-m-d H:i:s") . " - Birthday email to $name <$email> - " . ($result === true ? "Sent" : "Failed: $result") . "\n";
        file_put_contents(__DIR__ . "/logs/birthday.log", $log, FILE_APPEND);
    }
}
?>